/*
 * Decompiled with CFR 0.152.
 */
package de.mvbonline.tools.restapidoc.doclet;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.RootDoc;
import de.mvbonline.tools.restapidoc.doclet.model.ApiDescription;
import de.mvbonline.tools.restapidoc.doclet.model.ClassDescription;
import de.mvbonline.tools.restapidoc.doclet.model.ElementDescription;
import de.mvbonline.tools.restapidoc.doclet.model.MethodDescription;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class JavadocToXMLDoclet {
    public static final String FILENAME_APIDOC_XML = "apidoc.xml";

    public static boolean start(RootDoc root) throws Exception {
        ApiDescription apidoc = new ApiDescription();
        for (ClassDoc c : root.classes()) {
            ClassDescription doc = new ClassDescription();
            doc.setFullClassName(c.qualifiedName());
            doc.setName(c.name());
            doc.setDescription(c.commentText());
            for (FieldDoc fieldDoc : c.fields(false)) {
                doc.addProperty(new ElementDescription(fieldDoc.name(), fieldDoc.commentText()));
            }
            for (FieldDoc fieldDoc : c.methods(false)) {
                MethodDescription mdoc = new MethodDescription();
                mdoc.setName(fieldDoc.name());
                mdoc.setDescription(fieldDoc.commentText());
                if (fieldDoc.commentText() != null && fieldDoc.commentText().length() > 0) {
                    for (ParamTag paramTag : fieldDoc.paramTags()) {
                        mdoc.addParameter(new ElementDescription(paramTag.parameterName(), paramTag.parameterComment()));
                    }
                    for (ParamTag paramTag : fieldDoc.tags("return")) {
                        if (paramTag.text() == null || paramTag.text().length() <= 0) continue;
                        mdoc.setReturnValue(new ElementDescription("", paramTag.text()));
                    }
                }
                doc.addMethod(mdoc);
            }
            apidoc.addClass(doc);
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ApiDescription.class});
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.marshal((Object)apidoc, new File(FILENAME_APIDOC_XML));
        return true;
    }
}

