/*
 * Decompiled with CFR 0.152.
 */
package de.mvbonline.tools.restapidoc;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.jknack.handlebars.Handlebars;
import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Template;
import com.github.jknack.handlebars.helper.StringHelpers;
import de.mvbonline.tools.restapidoc.ApiDescriptionFinder;
import de.mvbonline.tools.restapidoc.HeaderHelper;
import de.mvbonline.tools.restapidoc.Jackson2ApiObjectDoc;
import de.mvbonline.tools.restapidoc.doclet.model.ClassDescription;
import de.mvbonline.tools.restapidoc.doclet.model.MethodDescription;
import de.mvbonline.tools.restapidoc.model.ApiBodyObjectDoc;
import de.mvbonline.tools.restapidoc.model.ApiDoc;
import de.mvbonline.tools.restapidoc.model.ApiMethodDoc;
import de.mvbonline.tools.restapidoc.model.ApiObjectDoc;
import de.mvbonline.tools.restapidoc.model.ApiParamDoc;
import de.mvbonline.tools.restapidoc.model.ApiResponseObjectDoc;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.classworlds.ClassRealm;
import org.codehaus.classworlds.ClassWorld;
import org.codehaus.classworlds.DuplicateRealmException;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestApiDocGeneratorMojo
extends AbstractMojo {
    private MavenProject project;
    private String packageName;
    private String jacksonObjectMapper;
    private String sourceDocFolder;
    private Handlebars handlebars = new Handlebars();
    private Reflections reflections;
    private ApiDescriptionFinder apiDescriptionsFinder;
    private File outputtFolder;
    private Set<ApiObjectDoc> modelObjects = new HashSet<ApiObjectDoc>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.outputtFolder = new File(new File(this.sourceDocFolder), "restapi");
            this.outputtFolder.mkdirs();
            this.setupClasspath();
            this.setupHandlerbars();
            this.reflections = new Reflections(this.packageName, new Scanner[0]);
            this.apiDescriptionsFinder = new ApiDescriptionFinder();
            Set controllers = this.reflections.getTypesAnnotatedWith(Controller.class);
            for (Class controller : controllers) {
                this.getLog().info((CharSequence)("Found Controller: " + controller.getName()));
                this.processRestApiController(controller);
            }
            this.fillModelFields();
            this.generateFile(this.modelObjects, "api_models", "models");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed", e);
        }
    }

    private void fillModelFields() {
        ObjectMapper objectMapper = null;
        if (!StringUtils.isBlank((CharSequence)this.jacksonObjectMapper)) {
            try {
                Class<?> mapperClass = Class.forName(this.jacksonObjectMapper, true, Thread.currentThread().getContextClassLoader());
                objectMapper = (ObjectMapper)mapperClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                this.getLog().warn((CharSequence)("Specified ObjectMapper not found " + this.jacksonObjectMapper));
            }
            catch (InstantiationException e) {
                this.getLog().warn((CharSequence)("Specified ObjectMapper could not be created " + this.jacksonObjectMapper));
            }
            catch (IllegalAccessException e) {
                this.getLog().warn((CharSequence)("Specified ObjectMapper could not be created " + this.jacksonObjectMapper));
            }
        }
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            this.getLog().info((CharSequence)"Using default ObjectMapper");
        }
        Jackson2ApiObjectDoc converter = new Jackson2ApiObjectDoc(objectMapper, this.apiDescriptionsFinder);
        for (ApiObjectDoc model : this.modelObjects) {
            try {
                converter.enrich(model);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateFile(Object doc, String templateName, String fileName) throws IOException {
        Template template = this.handlebars.compile(templateName);
        File f = new File(this.outputtFolder, fileName + ".rst");
        FileWriter fw = new FileWriter(f);
        fw.write(template.apply(doc));
        fw.close();
    }

    private List<ApiMethodDoc> getEndpointMethods(ClassDescription classDescription, Class<?> controller) {
        LinkedList<ApiMethodDoc> result = new LinkedList<ApiMethodDoc>();
        String basePath = "";
        if (controller.isAnnotationPresent(RequestMapping.class)) {
            basePath = controller.getAnnotation(RequestMapping.class).value()[0];
        }
        for (Method m : controller.getMethods()) {
            if (!m.isAnnotationPresent(RequestMapping.class) || !m.isAnnotationPresent(ResponseBody.class)) continue;
            RequestMapping rMappingAnno = m.getAnnotation(RequestMapping.class);
            ApiMethodDoc apiMethod = new ApiMethodDoc();
            apiMethod.setConsumes(Arrays.asList(rMappingAnno.consumes()));
            apiMethod.setProduces(Arrays.asList(rMappingAnno.produces()));
            apiMethod.setPath(basePath + rMappingAnno.value()[0]);
            apiMethod.setRequestMethod(rMappingAnno.method()[0]);
            MethodDescription methodDescription = this.apiDescriptionsFinder.getMethodDescription(classDescription, m.getName());
            apiMethod.setDescription(methodDescription != null ? methodDescription.getDescription() : "");
            Class<?>[] paramTypes = m.getParameterTypes();
            Annotation[][] paramAnnotations = m.getParameterAnnotations();
            LocalVariableTableParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
            String[] paramNames = parameterNameDiscoverer.getParameterNames(m);
            for (int i = 0; i < paramAnnotations.length; ++i) {
                for (Annotation annotation : paramAnnotations[i]) {
                    if (annotation instanceof RequestParam) {
                        Boolean required = ((RequestParam)annotation).required();
                        String name = ((RequestParam)annotation).value();
                        apiMethod.getQueryParameters().add(new ApiParamDoc(name, this.apiDescriptionsFinder.getElementDescription(methodDescription, paramNames[i]), paramTypes[i].getSimpleName(), required));
                        continue;
                    }
                    if (annotation instanceof PathVariable) {
                        apiMethod.getUrlparameters().add(new ApiParamDoc(((PathVariable)annotation).value(), this.apiDescriptionsFinder.getElementDescription(methodDescription, paramNames[i]), paramTypes[i].getSimpleName(), true));
                        continue;
                    }
                    if (!(annotation instanceof RequestBody)) continue;
                    apiMethod.setBodyobject(new ApiBodyObjectDoc(paramTypes[i].getSimpleName()));
                    ClassDescription modelObjectDescription = this.apiDescriptionsFinder.getClassDescription(paramTypes[i].getName());
                    this.modelObjects.add(new ApiObjectDoc(paramTypes[i].getSimpleName(), modelObjectDescription != null ? modelObjectDescription.getDescription() : "", paramTypes[i].getName()));
                }
            }
            ApiResponseObjectDoc apiResponseObjectDoc = new ApiResponseObjectDoc(m.getReturnType().getSimpleName());
            apiMethod.setResponse(apiResponseObjectDoc);
            result.add(apiMethod);
            ClassDescription modelObjectDescription = this.apiDescriptionsFinder.getClassDescription(m.getReturnType().getName());
            this.modelObjects.add(new ApiObjectDoc(m.getReturnType().getSimpleName(), modelObjectDescription != null ? modelObjectDescription.getDescription() : "", m.getReturnType().getName()));
        }
        return result;
    }

    private void processRestApiController(Class<?> controller) throws IOException {
        ApiDoc doc = new ApiDoc();
        doc.setName(controller.getSimpleName());
        ClassDescription classDescription = this.apiDescriptionsFinder.getClassDescription(controller.getName());
        doc.setDescription(classDescription != null ? classDescription.getDescription() : "");
        doc.setMethods(this.getEndpointMethods(classDescription, controller));
        if (doc.getMethods().isEmpty()) {
            this.getLog().info((CharSequence)("No RESTful methods found for controller " + controller.getName()));
            return;
        }
        this.generateFile(doc, "apidoc", doc.getName());
    }

    private void setupClasspath() throws DependencyResolutionRequiredException, DuplicateRealmException, MalformedURLException {
        List elements = this.project.getCompileClasspathElements();
        ClassWorld world = new ClassWorld();
        ClassRealm realm = world.newRealm("maven.plugin." + ((Object)((Object)this)).getClass().getSimpleName(), Thread.currentThread().getContextClassLoader());
        for (String e : elements) {
            File elementFile = new File(e);
            URL url = new URL("file:///" + elementFile.getPath() + (elementFile.isDirectory() ? "/" : ""));
            realm.addConstituent(url);
        }
        Thread.currentThread().setContextClassLoader(realm.getClassLoader());
    }

    private void setupHandlerbars() {
        this.handlebars.registerHelper(StringHelpers.lower.name(), (Helper)StringHelpers.lower);
        this.handlebars.registerHelper("header", (Helper)new HeaderHelper());
        this.handlebars.prettyPrint(true);
    }
}

