/*
 * Decompiled with CFR 0.152.
 */
package de.mvbonline.tools.restapidoc;

import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.mvbonline.tools.restapidoc.ApiDescriptionFinder;
import de.mvbonline.tools.restapidoc.doclet.model.ClassDescription;
import de.mvbonline.tools.restapidoc.model.ApiObjectDoc;
import de.mvbonline.tools.restapidoc.model.ApiObjectFieldDoc;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jackson2ApiObjectDoc {
    private ObjectMapper objectMapper;
    private ApiDescriptionFinder apiDescriptionFinder;

    public Jackson2ApiObjectDoc(ObjectMapper objectMapper, ApiDescriptionFinder apiDescriptionFinder) {
        this.objectMapper = objectMapper;
        this.apiDescriptionFinder = apiDescriptionFinder;
    }

    private Function<BeanPropertyDefinition, String> beanPropertyByInternalName() {
        return new Function<BeanPropertyDefinition, String>(){

            public String apply(BeanPropertyDefinition input) {
                return input.getInternalName();
            }
        };
    }

    public void enrich(ApiObjectDoc model) throws ClassNotFoundException {
        TypeResolver typeResolver = new TypeResolver();
        ResolvedType resolvedType = typeResolver.resolve(Class.forName(model.getModelClass(), true, Thread.currentThread().getContextClassLoader()), new Type[0]);
        SerializationConfig serializationConfig = this.objectMapper.getSerializationConfig();
        BeanDescription beanDescription = serializationConfig.introspect(TypeFactory.defaultInstance().constructType((Type)resolvedType.getErasedType()));
        MemberResolver memberResolver = new MemberResolver(typeResolver);
        ResolvedTypeWithMembers resolvedMemberWithMembers = memberResolver.resolve(resolvedType, null, null);
        ImmutableMap propertyLookup = Maps.uniqueIndex((Iterable)beanDescription.findProperties(), this.beanPropertyByInternalName());
        ClassDescription classDescription = this.apiDescriptionFinder.getClassDescription(model.getModelClass());
        for (ResolvedField childField : resolvedMemberWithMembers.getMemberFields()) {
            BeanPropertyDefinition propertyDefinition;
            AnnotatedField member;
            if (!propertyLookup.containsKey(childField.getName()) || (member = (propertyDefinition = (BeanPropertyDefinition)propertyLookup.get(childField.getName())).getField()) == null || member.getMember() == null || !Field.class.isAssignableFrom(member.getMember().getClass())) continue;
            ApiObjectFieldDoc apiField = new ApiObjectFieldDoc();
            apiField.setName(propertyDefinition.getName());
            apiField.setType(propertyDefinition.getField().getRawType().getSimpleName());
            apiField.setDescription(this.apiDescriptionFinder.getFieldDescription(classDescription, propertyDefinition.getName()));
            if (Collection.class.isAssignableFrom(propertyDefinition.getField().getRawType())) {
                apiField.setMultiple(true);
                if (propertyDefinition.getField().getGenericType() instanceof ParameterizedType) {
                    Class c = (Class)((ParameterizedType)propertyDefinition.getField().getGenericType()).getActualTypeArguments()[0];
                    apiField.setType(c.getSimpleName());
                }
            }
            model.addField(apiField);
        }
    }
}

