/*
 * Decompiled with CFR 0.152.
 */
package de.mvbonline.tools.restapidoc;

import de.mvbonline.tools.restapidoc.doclet.model.ApiDescription;
import de.mvbonline.tools.restapidoc.doclet.model.ClassDescription;
import de.mvbonline.tools.restapidoc.doclet.model.ElementDescription;
import de.mvbonline.tools.restapidoc.doclet.model.MethodDescription;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXB;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.io.Resource;

public class ApiDescriptionFinder {
    private ApiDescription apiDescriptions;

    public ApiDescriptionFinder() throws IOException {
        this.collectApiDescriptions();
    }

    private void collectApiDescriptions() throws IOException {
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
        Resource[] apidocsRes = applicationContext.getResources("classpath*:/META-INF/apidocs/apidoc.xml");
        this.apiDescriptions = new ApiDescription();
        for (Resource apidocRes : apidocsRes) {
            ApiDescription apidoc = (ApiDescription)JAXB.unmarshal((InputStream)apidocRes.getInputStream(), ApiDescription.class);
            this.apiDescriptions.addClasses(apidoc.getClasses());
        }
    }

    public ClassDescription getClassDescription(String className) {
        if (this.apiDescriptions != null && this.apiDescriptions.getClasses() != null) {
            for (ClassDescription classDoc : this.apiDescriptions.getClasses()) {
                if (!classDoc.getFullClassName().equals(className)) continue;
                return classDoc;
            }
        }
        return null;
    }

    public String getElementDescription(MethodDescription methodDesc, String name) {
        if (methodDesc != null && methodDesc.getParameters() != null) {
            for (ElementDescription elementDoc : methodDesc.getParameters()) {
                if (!elementDoc.getName().equals(name)) continue;
                return elementDoc.getDescription();
            }
        }
        return "";
    }

    public String getFieldDescription(ClassDescription classDesc, String name) {
        if (classDesc != null && classDesc.getProperties() != null) {
            for (ElementDescription elementDoc : classDesc.getProperties()) {
                if (!elementDoc.getName().equals(name)) continue;
                return elementDoc.getDescription();
            }
        }
        return "";
    }

    public MethodDescription getMethodDescription(ClassDescription classDesc, String name) {
        if (classDesc != null) {
            for (MethodDescription methodDoc : classDesc.getMethods()) {
                if (!methodDoc.getName().equals(name)) continue;
                return methodDoc;
            }
        }
        return null;
    }
}

