/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.utils;

import de.mtg.jzlint.utils.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;

public final class SMIMEUtils {
    public static final String MAILBOX_VALIDATED_LEGACY = "2.23.140.1.5.1.1";
    public static final String MAILBOX_VALIDATED_MULTIPURPOSE = "2.23.140.1.5.1.2";
    public static final String MAILBOX_VALIDATED_STRICT = "2.23.140.1.5.1.3";
    public static final String ORGANIZATION_VALIDATED_LEGACY = "2.23.140.1.5.2.1";
    public static final String ORGANIZATION_VALIDATED_MULTIPURPOSE = "2.23.140.1.5.2.2";
    public static final String ORGANIZATION_VALIDATED_STRICT = "2.23.140.1.5.2.3";
    public static final String SPONSOR_VALIDATED_LEGACY = "2.23.140.1.5.3.1";
    public static final String SPONSOR_VALIDATED_MULTIPURPOSE = "2.23.140.1.5.3.2";
    public static final String SPONSOR_VALIDATED_STRICT = "2.23.140.1.5.3.3";
    public static final String INDIVIDUAL_VALIDATED_LEGACY = "2.23.140.1.5.4.1";
    public static final String INDIVIDUAL_VALIDATED_MULTIPURPOSE = "2.23.140.1.5.4.2";
    public static final String INDIVIDUAL_VALIDATED_STRICT = "2.23.140.1.5.4.3";
    private static final List<String> MAILBOX_VALIDATED_OIDS = Arrays.asList("2.23.140.1.5.1.1", "2.23.140.1.5.1.2", "2.23.140.1.5.1.3");
    private static final List<String> LEGACY_OIDS = Arrays.asList("2.23.140.1.5.1.1", "2.23.140.1.5.2.1", "2.23.140.1.5.3.1", "2.23.140.1.5.4.1");
    private static final List<String> MULTIPURPOSE_OIDS = Arrays.asList("2.23.140.1.5.1.2", "2.23.140.1.5.2.2", "2.23.140.1.5.3.2", "2.23.140.1.5.4.2");
    private static final List<String> STRICT_OIDS = Arrays.asList("2.23.140.1.5.1.3", "2.23.140.1.5.2.3", "2.23.140.1.5.3.3", "2.23.140.1.5.4.3");
    private static final List<String> ORGANIZATION_VALIDATED_OIDS = Arrays.asList("2.23.140.1.5.2.1", "2.23.140.1.5.2.2", "2.23.140.1.5.2.3", "2.23.140.1.5.4.3");
    private static final List<String> SPONSOR_VALIDATED_OIDS = Arrays.asList("2.23.140.1.5.3.1", "2.23.140.1.5.3.2", "2.23.140.1.5.3.3");
    private static final List<String> INDIVIDUAL_VALIDATED_OIDS = Arrays.asList("2.23.140.1.5.4.1", "2.23.140.1.5.4.2", "2.23.140.1.5.4.3");
    private static final Function<PolicyInformation, String> getOID = p -> p.getPolicyIdentifier().getId();
    private static final String REGEX_PATTERN = "^(?=.{1,64}@)[\\p{L}0-9_-]+(\\.[\\p{L}0-9_-]+)*@[^-][\\p{L}0-9-]+(\\.[\\p{L}0-9-]+)*(\\.[\\p{L}]{2,})$";
    private static final String REGEX_PATTERN_PLUS = "^(?=.{1,64}@)[A-Za-z0-9\\+_-]+(\\.[A-Za-z0-9\\+_-]+)*@[^-][A-Za-z0-9\\+-]+(\\.[A-Za-z0-9\\+-]+)*(\\.[A-Za-z]{2,})$";
    private static final Pattern PATTERN = Pattern.compile("^(?=.{1,64}@)[\\p{L}0-9_-]+(\\.[\\p{L}0-9_-]+)*@[^-][\\p{L}0-9-]+(\\.[\\p{L}0-9-]+)*(\\.[\\p{L}]{2,})$");
    private static final Pattern PATTERN_PLUS = Pattern.compile("^(?=.{1,64}@)[A-Za-z0-9\\+_-]+(\\.[A-Za-z0-9\\+_-]+)*@[^-][A-Za-z0-9\\+-]+(\\.[A-Za-z0-9\\+-]+)*(\\.[A-Za-z]{2,})$");

    private SMIMEUtils() {
    }

    public static boolean isMailboxValidatedCertificate(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        if (rawCertificatePolicies == null) {
            return false;
        }
        byte[] value = ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        Predicate<PolicyInformation> isMailboxValidatedPolicy = p -> MAILBOX_VALIDATED_OIDS.contains(getOID.apply((PolicyInformation)p));
        return Arrays.stream(certificatePolicies.getPolicyInformation()).anyMatch(isMailboxValidatedPolicy);
    }

    public static boolean isLegacySMIMECertificate(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        if (rawCertificatePolicies == null) {
            return false;
        }
        byte[] value = ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        Predicate<PolicyInformation> isLegacy = p -> LEGACY_OIDS.contains(getOID.apply((PolicyInformation)p));
        return Arrays.stream(certificatePolicies.getPolicyInformation()).anyMatch(isLegacy);
    }

    public static boolean isMultipurposeSMIMECertificate(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        if (rawCertificatePolicies == null) {
            return false;
        }
        byte[] value = ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        Predicate<PolicyInformation> isMailboxValidatedPolicy = p -> MULTIPURPOSE_OIDS.contains(getOID.apply((PolicyInformation)p));
        return Arrays.stream(certificatePolicies.getPolicyInformation()).anyMatch(isMailboxValidatedPolicy);
    }

    public static boolean isStrictSMIMECertificate(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        if (rawCertificatePolicies == null) {
            return false;
        }
        byte[] value = ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        Predicate<PolicyInformation> isStrictPolicy = p -> STRICT_OIDS.contains(getOID.apply((PolicyInformation)p));
        return Arrays.stream(certificatePolicies.getPolicyInformation()).anyMatch(isStrictPolicy);
    }

    public static boolean isSMIMEBRCertificate(X509Certificate certificate) {
        return SMIMEUtils.isLegacySMIMECertificate(certificate) || SMIMEUtils.isMultipurposeSMIMECertificate(certificate) || SMIMEUtils.isStrictSMIMECertificate(certificate);
    }

    public static boolean isSMIMEBRSubscriberCertificate(X509Certificate certificate) {
        return Utils.isSubscriberCert(certificate) && SMIMEUtils.isSMIMEBRCertificate(certificate);
    }

    public static boolean isOrganizationValidatedCertificate(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        if (rawCertificatePolicies == null) {
            return false;
        }
        byte[] value = ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        Predicate<PolicyInformation> isOrganizationValidatedPolicy = p -> ORGANIZATION_VALIDATED_OIDS.contains(getOID.apply((PolicyInformation)p));
        return Arrays.stream(certificatePolicies.getPolicyInformation()).anyMatch(isOrganizationValidatedPolicy);
    }

    public static boolean isSponsorValidatedCertificate(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        if (rawCertificatePolicies == null) {
            return false;
        }
        byte[] value = ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        Predicate<PolicyInformation> isSponsorValidatedPolicy = p -> SPONSOR_VALIDATED_OIDS.contains(getOID.apply((PolicyInformation)p));
        return Arrays.stream(certificatePolicies.getPolicyInformation()).anyMatch(isSponsorValidatedPolicy);
    }

    public static boolean isIndividualValidatedCertificate(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        if (rawCertificatePolicies == null) {
            return false;
        }
        byte[] value = ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)value);
        Predicate<PolicyInformation> isIndividualValidatedPolicy = p -> INDIVIDUAL_VALIDATED_OIDS.contains(getOID.apply((PolicyInformation)p));
        return Arrays.stream(certificatePolicies.getPolicyInformation()).anyMatch(isIndividualValidatedPolicy);
    }

    public static boolean isValidEmailAddress(String candidate) {
        return PATTERN.matcher(candidate).matches() || PATTERN_PLUS.matcher(candidate).matches();
    }

    public static List<String> getSmtpUTF8Mailboxes(X509Certificate certificate) throws IOException {
        byte[] rawSAN = certificate.getExtensionValue(Extension.subjectAlternativeName.getId());
        if (rawSAN == null) {
            return new ArrayList<String>();
        }
        GeneralNames generalNames = Utils.getGeneralNames(rawSAN);
        GeneralName[] names = generalNames.getNames();
        ArrayList otherNames = new ArrayList();
        Arrays.stream(names).filter(generalName -> generalName.getTagNo() == 0).forEach(otherNames::add);
        ArrayList<String> emails = new ArrayList<String>();
        for (GeneralName otherName : otherNames) {
            byte[] encoded = otherName.getEncoded("DER");
            ASN1Sequence sequence = ASN1Sequence.getInstance((Object)ASN1TaggedObject.getInstance((Object)encoded).getBaseObject());
            ASN1ObjectIdentifier typeId = (ASN1ObjectIdentifier)sequence.getObjectAt(0);
            if (!"1.3.6.1.5.5.7.8.9".equals(typeId.getId())) continue;
            ASN1TaggedObject taggedObject = (ASN1TaggedObject)sequence.getObjectAt(1);
            ASN1UTF8String utf8String = (ASN1UTF8String)taggedObject.getBaseObject();
            emails.add(utf8String.getString());
        }
        return emails;
    }
}

