/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.utils;

import de.mtg.jzlint.utils.DomainStringUtils;
import de.mtg.jzlint.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.IDN;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class ParsedDomainName {
    public static final String ERROR_INVALID_DOMAIN = "Invalid TLD.";
    private final String tld;
    private final String sld;
    private final String trd;
    private final String error;

    private ParsedDomainName(String tld, String sld, String trd, String error) {
        this.tld = tld;
        this.sld = sld;
        this.trd = trd;
        this.error = error;
    }

    private static ParsedDomainName fromError(String error) {
        return new ParsedDomainName("", "", "", error);
    }

    private static List<Map<String, Boolean>> getMatchingRules(String domain, boolean publicOnly) {
        String line;
        byte[] file;
        ClassLoader classLoader = ParsedDomainName.class.getClassLoader();
        byte[] buffer = new byte[1024];
        try (InputStream inputStream = classLoader.getResourceAsStream("public_suffix_list.dat");
             ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            int length;
            while ((length = inputStream.read(buffer)) != -1) {
                baos.write(buffer, 0, length);
            }
            file = baos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String publicSuffixList = new String(file, StandardCharsets.UTF_8);
        ArrayList<Map<String, Boolean>> matchingRules = new ArrayList<Map<String, Boolean>>();
        boolean isPublicRule = true;
        String[] lines = publicSuffixList.split("\n");
        for (int i = 0; !(i >= lines.length || (line = lines[i]).contains("===BEGIN PRIVATE DOMAINS===") && publicOnly); ++i) {
            if (line.contains("===BEGIN PRIVATE DOMAINS===")) {
                isPublicRule = false;
            }
            if (line.trim().startsWith("//") || line.trim().isEmpty()) continue;
            String rule = line.trim();
            if (line.trim().startsWith("!")) {
                rule = line.trim().substring(1);
            }
            if (!DomainStringUtils.domainMatches(domain, rule = IDN.toASCII(rule))) continue;
            matchingRules.add(Collections.singletonMap(line.trim(), isPublicRule));
        }
        return matchingRules;
    }

    private static Map<String, Boolean> getPrevailingRule(String domain, boolean publicOnly) {
        List<Map<String, Boolean>> matchingRules = ParsedDomainName.getMatchingRules(domain, publicOnly);
        if (matchingRules.size() == 0) {
            return Collections.singletonMap("*", true);
        }
        for (Map<String, Boolean> matchingRule : matchingRules) {
            Optional<String> exclamationRule = matchingRule.keySet().stream().filter(rule -> rule.startsWith("!")).findFirst();
            if (!exclamationRule.isPresent()) continue;
            String matchingRuleWithoutLeftmostLabel = StringUtils.getAfterFirstDot(exclamationRule.get()).get();
            return Collections.singletonMap(matchingRuleWithoutLeftmostLabel, matchingRule.entrySet().iterator().next().getValue());
        }
        Map<String, Boolean> prevailingRule = null;
        int size = 0;
        for (Map<String, Boolean> matchingRule : matchingRules) {
            String rule2 = matchingRule.keySet().iterator().next();
            int matchingRuleLabelSize = DomainStringUtils.getLabels(rule2).size();
            if (matchingRuleLabelSize <= size) continue;
            size = matchingRuleLabelSize;
            prevailingRule = matchingRule;
        }
        return prevailingRule;
    }

    private static String getPublicSuffix(String domain, Map<String, Boolean> prevailingRule) {
        String rule = prevailingRule.keySet().iterator().next();
        List<String> domainLabels = DomainStringUtils.getLabels(domain);
        List<String> ruleLabels = DomainStringUtils.getLabels(rule);
        StringBuilder publicSuffixBuilder = new StringBuilder();
        for (int i = 0; i < ruleLabels.size(); ++i) {
            String ruleLabel = ruleLabels.get(i);
            String domainLabel = domainLabels.get(i);
            publicSuffixBuilder.insert(0, ".");
            publicSuffixBuilder.insert(1, domainLabel);
            if (!ruleLabel.equals("*")) continue;
            return publicSuffixBuilder.deleteCharAt(0).toString();
        }
        return publicSuffixBuilder.deleteCharAt(0).toString();
    }

    private static ParsedDomainName fromDomain(String domain, boolean publicOnly) {
        String canonicalizedDomain = IDN.toASCII(domain);
        Map<String, Boolean> prevailingRule = ParsedDomainName.getPrevailingRule(canonicalizedDomain, publicOnly);
        String publicSuffix = ParsedDomainName.getPublicSuffix(canonicalizedDomain, prevailingRule);
        Boolean isPublic = prevailingRule.entrySet().iterator().next().getValue();
        if (isPublic.booleanValue()) {
            if (publicSuffix.equalsIgnoreCase(canonicalizedDomain)) {
                return new ParsedDomainName("", "", "", ERROR_INVALID_DOMAIN);
            }
            Optional<String> withoutEnding = StringUtils.getWithoutEnding(canonicalizedDomain, "." + publicSuffix);
            String notTLD = withoutEnding.get();
            String[] sldTrd = ParsedDomainName.separateSLDAndTRD(notTLD);
            return new ParsedDomainName(IDN.toUnicode(publicSuffix), IDN.toUnicode(sldTrd[0]), IDN.toUnicode(sldTrd[1]), null);
        }
        return ParsedDomainName.fromDomain(canonicalizedDomain, true);
    }

    public static ParsedDomainName fromDomain(String domain) {
        return ParsedDomainName.fromDomain(domain, false);
    }

    private static String[] separateSLDAndTRD(String input) {
        String trd;
        String sld;
        String[] returnValue = new String[2];
        if (input.contains(".")) {
            sld = StringUtils.getAfterLastDot(input).get();
            trd = StringUtils.getBeforeLastDot(input).get();
        } else {
            sld = input;
            trd = "";
        }
        returnValue[0] = sld;
        returnValue[1] = trd;
        return returnValue;
    }

    public String getTld() {
        return this.tld;
    }

    public String getSld() {
        return this.sld;
    }

    public String getTrd() {
        return this.trd;
    }

    public String getError() {
        return this.error;
    }
}

