/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.ASN1CertificateUtils;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

@Lint(name="e_wrong_time_format_pre2050", description="Certificates valid through the year 2049 MUST be encoded in UTC time", citation="RFC 5280: 4.1.2.5", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class WrongTimeFormatPre2050
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        try {
            Date notBefore = certificate.getNotBefore();
            if (WrongTimeFormatPre2050.isDateIn2050(notBefore) ? !ASN1CertificateUtils.notBeforeIsGeneralizedTime(certificate) : ASN1CertificateUtils.notBeforeIsGeneralizedTime(certificate)) {
                return LintResult.of(Status.ERROR);
            }
            Date notAfter = certificate.getNotAfter();
            if (WrongTimeFormatPre2050.isDateIn2050(notAfter) ? !ASN1CertificateUtils.notAfterIsGeneralizedTime(certificate) : ASN1CertificateUtils.notAfterIsGeneralizedTime(certificate)) {
                return LintResult.of(Status.ERROR);
            }
        }
        catch (IOException | CertificateEncodingException ex) {
            return LintResult.of(Status.FATAL);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return true;
    }

    private static boolean isDateIn2050(Date certificateDate) {
        return !WrongTimeFormatPre2050.isBefore2050(certificateDate);
    }

    private static boolean isBefore2050(Date certificateDate) {
        ZonedDateTime certificateZonedDateTime = ZonedDateTime.ofInstant(certificateDate.toInstant(), ZoneId.of("UTC"));
        return certificateZonedDateTime.isBefore(EffectiveDate.GeneralizedDate.getZonedDateTime());
    }
}

