/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_path_len_constraint_zero_or_less", description="Where it appears, the pathLenConstraint field MUST be greater than or equal to zero", citation="RFC 5280: 4.2.1.9", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class PathLenConstraintZeroOrLess
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawBasicConstraints = certificate.getExtensionValue(Extension.basicConstraints.getId());
        BasicConstraints basicConstraints = BasicConstraints.getInstance((Object)ASN1OctetString.getInstance((Object)rawBasicConstraints).getOctets());
        ASN1Sequence basicConstraintsSeq = ASN1Sequence.getInstance((Object)ASN1OctetString.getInstance((Object)rawBasicConstraints).getOctets());
        if (basicConstraintsSeq.size() == 0) {
            return LintResult.of(Status.PASS);
        }
        if (basicConstraints.getPathLenConstraint() == null) {
            return LintResult.of(Status.PASS);
        }
        if (basicConstraints.getPathLenConstraint().compareTo(BigInteger.ZERO) == -1) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasBasicConstraintsExtension(certificate);
    }
}

