/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.lints.rfc.NameConstraintOnEdiPartyName;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="w_name_constraint_on_registered_id", description="The name constraints extension SHOULD NOT impose constraints on the registeredID name form", citation="RFC 5280: 4.2.1.10", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class NameConstraintOnRegisteredId
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        return NameConstraintOnEdiPartyName.nameConstraintsHaveBaseWithTag(certificate, 8);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.nameConstraints.getId());
    }
}

