/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;

@Lint(name="w_name_constraint_on_edi_party_name", description="The name constraints extension SHOULD NOT impose constraints on the ediPartyName name form", citation="RFC 5280: 4.2.1.10", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class NameConstraintOnEdiPartyName
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        return NameConstraintOnEdiPartyName.nameConstraintsHaveBaseWithTag(certificate, 5);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.nameConstraints.getId());
    }

    protected static LintResult nameConstraintsHaveBaseWithTag(X509Certificate certificate, int tagNumber) {
        byte[] rawNameConstraints = certificate.getExtensionValue(Extension.nameConstraints.getId());
        NameConstraints nameConstraints = NameConstraints.getInstance((Object)ASN1OctetString.getInstance((Object)rawNameConstraints).getOctets());
        GeneralSubtree[] excludedSubtrees = nameConstraints.getExcludedSubtrees();
        if (NameConstraintOnEdiPartyName.containsTag(excludedSubtrees, tagNumber)) {
            return LintResult.of(Status.WARN);
        }
        GeneralSubtree[] permittedSubtrees = nameConstraints.getPermittedSubtrees();
        if (NameConstraintOnEdiPartyName.containsTag(permittedSubtrees, tagNumber)) {
            return LintResult.of(Status.WARN);
        }
        return LintResult.of(Status.PASS);
    }

    private static boolean containsTag(GeneralSubtree[] subtrees, int tagNumber) {
        if (subtrees == null) {
            return false;
        }
        return Arrays.stream(subtrees).anyMatch(subtree -> subtree.getBase().getTagNo() == tagNumber);
    }
}

