/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.NameConstraints;

@Lint(name="e_name_constraint_minimum_non_zero", description="Within the name constraints name forms, the minimum field is not used and therefore MUST be zero", citation="RFC 5280: 4.2.1.10", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class NameConstraintMinimumNonZero
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        GeneralSubtree[] permittedSubtrees;
        byte[] rawNameConstraints = certificate.getExtensionValue(Extension.nameConstraints.getId());
        NameConstraints nameConstraints = NameConstraints.getInstance((Object)ASN1OctetString.getInstance((Object)rawNameConstraints).getOctets());
        GeneralSubtree[] excludedSubtrees = nameConstraints.getExcludedSubtrees();
        if (excludedSubtrees != null) {
            for (GeneralSubtree excludedSubtree : excludedSubtrees) {
                if (excludedSubtree.getMinimum() == null || excludedSubtree.getMinimum().intValue() == 0) continue;
                return LintResult.of(Status.ERROR);
            }
        }
        if ((permittedSubtrees = nameConstraints.getPermittedSubtrees()) != null) {
            for (GeneralSubtree permittedSubtree : permittedSubtrees) {
                if (permittedSubtree.getMinimum() == null || permittedSubtree.getMinimum().intValue() == 0) continue;
                return LintResult.of(Status.ERROR);
            }
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.nameConstraints.getId());
    }
}

