/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_name_constraint_empty", description="Conforming CAs MUST NOT issue certificates where name constraints is an empty sequence. That is, either the permittedSubtree or excludedSubtree fields must be present", citation="RFC 5280: 4.2.1.10", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class NameConstraintEmpty
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawNameConstraints = certificate.getExtensionValue(Extension.nameConstraints.getId());
        ASN1Sequence nameConstraintsValue = ASN1Sequence.getInstance((Object)ASN1OctetString.getInstance((Object)rawNameConstraints).getOctets());
        if (nameConstraintsValue.size() < 1) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.nameConstraints.getId());
    }
}

