/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;

@Lint(name="e_key_usage_and_extended_key_usage_inconsistent", description="The certificate MUST only be used for a purpose consistent with both key usage extension and extended key usage extension.", citation="RFC 5280, Section 4.2.1.12.", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class KeyUsageAndExtendedKeyUsageInconsistent
implements JavaLint {
    private static final List<Integer> CONSISTENT_SERVER_AUTH = Arrays.asList(128, 32, 8, 160, 136);
    private static final List<Integer> CONSISTENT_CLIENT_AUTH = Arrays.asList(128, 8, 136);
    private static final List<Integer> CONSISTENT_CODE_SIGNING = Arrays.asList(128);
    private static final List<Integer> CONSISTENT_EMAIL_PROTECTION = Arrays.asList(128, 64, 32, 8, 192, 160, 136, 224, 200, 96, 72);
    private static final List<Integer> CONSISTENT_TIME_STAMPING = Arrays.asList(128, 64, 192);
    private static final List<Integer> CONSISTENT_OCSP = Arrays.asList(128, 64, 192);

    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawEKU = certificate.getExtensionValue(Extension.extendedKeyUsage.getId());
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)ASN1OctetString.getInstance((Object)rawEKU).getOctets());
        byte[] rawKeyUsage = certificate.getExtensionValue(Extension.keyUsage.getId());
        byte[] rawValue = ASN1OctetString.getInstance((Object)rawKeyUsage).getOctets();
        ASN1BitString asn1BitString = ASN1BitString.getInstance((Object)rawValue);
        int rawKeyUsageValue = asn1BitString.intValue();
        int n = 0;
        KeyPurposeId[] usages = extendedKeyUsage.getUsages();
        KeyPurposeId[] keyPurposeIdArray = usages;
        int n2 = keyPurposeIdArray.length;
        if (n < n2) {
            KeyPurposeId keyPurposeId = keyPurposeIdArray[n];
            if (KeyPurposeId.id_kp_serverAuth.toOID().equals((ASN1Primitive)keyPurposeId.toOID()) && CONSISTENT_SERVER_AUTH.contains(rawKeyUsageValue)) {
                return LintResult.of(Status.PASS);
            }
            if (KeyPurposeId.id_kp_clientAuth.toOID().equals((ASN1Primitive)keyPurposeId.toOID()) && CONSISTENT_CLIENT_AUTH.contains(rawKeyUsageValue)) {
                return LintResult.of(Status.PASS);
            }
            if (KeyPurposeId.id_kp_codeSigning.toOID().equals((ASN1Primitive)keyPurposeId.toOID()) && CONSISTENT_CODE_SIGNING.contains(rawKeyUsageValue)) {
                return LintResult.of(Status.PASS);
            }
            if (KeyPurposeId.id_kp_emailProtection.toOID().equals((ASN1Primitive)keyPurposeId.toOID()) && CONSISTENT_EMAIL_PROTECTION.contains(rawKeyUsageValue)) {
                return LintResult.of(Status.PASS);
            }
            if (KeyPurposeId.id_kp_timeStamping.toOID().equals((ASN1Primitive)keyPurposeId.toOID()) && CONSISTENT_TIME_STAMPING.contains(rawKeyUsageValue)) {
                return LintResult.of(Status.PASS);
            }
            if (KeyPurposeId.id_kp_OCSPSigning.toOID().equals((ASN1Primitive)keyPurposeId.toOID()) && CONSISTENT_OCSP.contains(rawKeyUsageValue)) {
                return LintResult.of(Status.PASS);
            }
            return LintResult.of(Status.ERROR, "KeyUsage inconsistent with ExtKeyUsage");
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isSubscriberCert(certificate) && Utils.hasExtendedKeyUsageExtension(certificate) && Utils.hasKeyUsageExtension(certificate);
    }
}

