/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.ASN1CertificateUtils;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1GeneralizedTime;

@Lint(name="e_generalized_time_includes_fraction_seconds", description="Generalized time values MUST NOT include fractional seconds", citation="RFC 5280: 4.1.2.5.2", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class GeneralizedTimeIncludesFractionSeconds
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        try {
            ASN1GeneralizedTime generalizedTime;
            if (ASN1CertificateUtils.notBeforeIsGeneralizedTime(certificate) && ASN1CertificateUtils.generalizedTimeHasFractionSeconds(generalizedTime = (ASN1GeneralizedTime)ASN1CertificateUtils.getNotBefore(certificate))) {
                return LintResult.of(Status.ERROR);
            }
            if (ASN1CertificateUtils.notAfterIsGeneralizedTime(certificate) && ASN1CertificateUtils.generalizedTimeHasFractionSeconds(generalizedTime = (ASN1GeneralizedTime)ASN1CertificateUtils.getNotAfter(certificate))) {
                return LintResult.of(Status.ERROR);
            }
        }
        catch (IOException | CertificateEncodingException ex) {
            return LintResult.of(Status.FATAL);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        try {
            return ASN1CertificateUtils.notBeforeIsGeneralizedTime(certificate) || ASN1CertificateUtils.notAfterIsGeneralizedTime(certificate);
        }
        catch (IOException | CertificateEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }
}

