/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.lints.rfc.ExtSanUriNotIa5;
import de.mtg.jzlint.utils.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;

@Lint(name="e_ext_san_dns_not_ia5_string", description="dNSNames MUST be IA5 strings", citation="RFC 5280: 4.2.1.6", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class ExtSanDnsNotIa5String
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawSAN = certificate.getExtensionValue(Extension.subjectAlternativeName.getId());
        try {
            List<GeneralName> dnsNames = Utils.getDNSNames(rawSAN);
            return ExtSanUriNotIa5.isGeneralNameNotIa5(dnsNames);
        }
        catch (IOException ex) {
            return LintResult.of(Status.FATAL);
        }
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.subjectAlternativeName.getId());
    }
}

