/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.lints.rfc.ExtSanUriRelative;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_ext_ian_uri_relative", description="When issuerAltName extension is present and the URI is used, the name MUST NOT be a relative URI", citation="RFC 5280: 4.2.1.7", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class ExtIanUriRelative
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawIAN = certificate.getExtensionValue(Extension.issuerAlternativeName.getId());
        return ExtSanUriRelative.isURIAbsolute(rawIAN);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.issuerAlternativeName.getId());
    }
}

