/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1BMPString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.ASN1VisibleString;

@Lint(name="e_ext_cert_policy_explicit_text_too_long", description="Explicit text has a maximum size of 200 characters", citation="RFC 6818: 3", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC6818)
public class ExtCertPolicyExplicitTextTooLong
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        List<ASN1Encodable> explicitTextList = Utils.getExplicitTextList(certificate);
        for (ASN1Encodable explicitText : explicitTextList) {
            String text = null;
            if (explicitText instanceof ASN1UTF8String) {
                text = ((ASN1UTF8String)explicitText).getString();
            }
            if (explicitText instanceof ASN1BMPString) {
                text = ((ASN1BMPString)explicitText).getString();
            }
            if (explicitText instanceof ASN1VisibleString) {
                text = ((ASN1VisibleString)explicitText).getString();
            }
            if (explicitText instanceof ASN1IA5String) {
                text = ((ASN1IA5String)explicitText).getString();
            }
            if (text == null || text.length() <= 200) continue;
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        if (!Utils.hasCertificatePoliciesExtension(certificate)) {
            return false;
        }
        return !Utils.getExplicitTextList(certificate).isEmpty();
    }
}

