/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;

@Lint(name="w_ext_cert_policy_explicit_text_not_utf8", description="Compliant certificates should use the utf8string encoding for explicitText", citation="RFC 6818: 3", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC6818)
public class ExtCertPolicyExplicitTextNotUtf8
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        List<ASN1Encodable> explicitTextList = Utils.getExplicitTextList(certificate);
        for (ASN1Encodable explicitText : explicitTextList) {
            try {
                if (explicitText.toASN1Primitive().getEncoded("DER")[0] == 12) continue;
                return LintResult.of(Status.WARN);
            }
            catch (IOException ex) {
                return LintResult.of(Status.FATAL);
            }
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        if (!Utils.hasCertificatePoliciesExtension(certificate)) {
            return false;
        }
        return !Utils.getExplicitTextList(certificate).isEmpty();
    }
}

