/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.text.Normalizer;
import java.util.List;
import org.bouncycastle.asn1.ASN1BMPString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1UTF8String;

@Lint(name="w_ext_cert_policy_explicit_text_not_nfc", description="When utf8string or bmpstring encoding is used for explicitText field in certificate policy, it SHOULD be normalized by NFC format", citation="RFC 6818 3", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC6818)
public class ExtCertPolicyExplicitTextNotNfc
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        List<ASN1Encodable> explicitTextList = Utils.getExplicitTextList(certificate);
        for (ASN1Encodable explicitText : explicitTextList) {
            String text;
            if (explicitText instanceof ASN1UTF8String && !Normalizer.isNormalized(text = ((ASN1UTF8String)explicitText).getString(), Normalizer.Form.NFC)) {
                return LintResult.of(Status.WARN);
            }
            if (!(explicitText instanceof ASN1BMPString) || Normalizer.isNormalized(text = ((ASN1BMPString)explicitText).getString(), Normalizer.Form.NFC)) continue;
            return LintResult.of(Status.WARN);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        if (!Utils.hasCertificatePoliciesExtension(certificate)) {
            return false;
        }
        return !Utils.getExplicitTextList(certificate).isEmpty();
    }
}

