/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;

@Lint(name="e_ext_cert_policy_explicit_text_ia5_string", description="Compliant certificates must not encode explicitTest as an IA5String", citation="RFC 5280: 4.2.1.4", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC6818)
public class ExtCertPolicyExplicitTextIa5String
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        List<ASN1Encodable> explicitTextList = Utils.getExplicitTextList(certificate);
        for (ASN1Encodable explicitText : explicitTextList) {
            try {
                byte[] encoded = explicitText.toASN1Primitive().getEncoded("DER");
                byte tag = encoded[0];
                if (tag != 22) continue;
                return LintResult.of(Status.ERROR);
            }
            catch (IOException ex) {
                return LintResult.of(Status.FATAL);
            }
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        if (!Utils.hasCertificatePoliciesExtension(certificate)) {
            return false;
        }
        List<ASN1Encodable> explicitTextList = Utils.getExplicitTextList(certificate);
        return explicitTextList.isEmpty();
    }
}

