/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;

@Lint(name="w_ext_cert_policy_contains_noticeref", description="Compliant certificates SHOULD NOT use the noticeRef option", citation="RFC 5280: 4.2.1.4", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class ExtCertPolicyContainsNoticeref
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets());
        for (PolicyInformation policyInformation : certificatePolicies.getPolicyInformation()) {
            ASN1Encodable[] policyQualifiers;
            ASN1Sequence policyQualifiersSequence = policyInformation.getPolicyQualifiers();
            if (policyQualifiersSequence == null) {
                return LintResult.of(Status.PASS);
            }
            for (ASN1Encodable policyQualifier : policyQualifiers = policyQualifiersSequence.toArray()) {
                ASN1Encodable firstElement;
                ASN1Encodable qualifier;
                ASN1ObjectIdentifier policyQualifierId = (ASN1ObjectIdentifier)((ASN1Sequence)policyQualifier).getObjectAt(0);
                if (!PolicyQualifierId.id_qt_unotice.getId().equals(policyQualifierId.getId()) || !((qualifier = ((ASN1Sequence)policyQualifier).getObjectAt(1)) instanceof ASN1Sequence) || !((firstElement = ((ASN1Sequence)qualifier).getObjectAt(0)) instanceof ASN1Sequence)) continue;
                return LintResult.of(Status.WARN);
            }
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasCertificatePoliciesExtension(certificate);
    }
}

