/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;

@Lint(name="w_eku_critical_improperly", description="Conforming CAs SHOULD NOT mark extended key usage extension as critical if the anyExtendedKeyUsage KeyPurposedID is present", citation="RFC 5280: 4.2.1.12", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC3280)
public class EkuCriticalImproperly
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawEKU;
        ExtendedKeyUsage extendedKeyUsage;
        if (Utils.isExtendedKeyUsageExtensionCritical(certificate) && (extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)ASN1OctetString.getInstance((Object)(rawEKU = certificate.getExtensionValue(Extension.extendedKeyUsage.getId()))).getOctets())).hasKeyPurposeId(KeyPurposeId.anyExtendedKeyUsage)) {
            return LintResult.of(Status.WARN);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtendedKeyUsageExtension(certificate);
    }
}

