/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;

@Lint(name="e_ecdsa_allowed_ku", description="Key usage values keyEncipherment or dataEncipherment MUST NOT be present in certificates with ECDSA public keys", citation="RFC 8813 Section 3", source=Source.RFC8813, effectiveDate=EffectiveDate.RFC8813)
public class EcdsaAllowedKu
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawKeyUsage = certificate.getExtensionValue(Extension.keyUsage.getId());
        KeyUsage keyUsage = KeyUsage.getInstance((Object)ASN1OctetString.getInstance((Object)rawKeyUsage).getOctets());
        StringBuilder stringBuilder = new StringBuilder();
        if (keyUsage.hasUsages(32)) {
            stringBuilder.append("keyEncipherment");
        }
        if (keyUsage.hasUsages(16)) {
            stringBuilder.append(", dataEncipherment");
        }
        if (!stringBuilder.toString().isEmpty()) {
            return LintResult.of(Status.ERROR, String.format("Certificate contains invalid key usage(s): %s", stringBuilder.toString()));
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasKeyUsageExtension(certificate) && Utils.isPublicKeyECC(certificate);
    }
}

