/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import java.security.cert.X509Certificate;

@Lint(name="e_cert_contains_unique_identifier", description="CAs MUST NOT generate certificate with unique identifiers", citation="RFC 5280: 4.1.2.8", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class CertContainsUniqueIdentifier
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (certificate.getIssuerUniqueID() == null && certificate.getSubjectUniqueID() == null) {
            return LintResult.of(Status.PASS);
        }
        return LintResult.of(Status.ERROR);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return true;
    }
}

