/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.mozilla;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;

@Lint(name="e_prohibit_dsa_usage", description="DSA is not an explicitly allowed signature algorithm, therefore it is forbidden.", citation="Mozilla Root Store Policy / Section 5.1", source=Source.MOZILLA_ROOT_STORE_POLICY, effectiveDate=EffectiveDate.MozillaPolicy241Date)
public class ProhibitDsaUsage
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (Utils.isPublicKeyDSA(certificate)) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return true;
    }
}

