/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.etsi;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.lints.etsi.QcUtils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;

@Lint(name="e_qcstatem_qcsscd_valid", description="Checks that a QC Statement of the type id-etsi-qcs-QcSSCD has the correct form", citation="ETSI EN 319 412 - 5 V2.2.1 (2017 - 11) / Section 4.2.2", source=Source.ETSI_ESI, effectiveDate=EffectiveDate.EtsiEn319_412_5_V2_2_1_Date)
public class QcstatemQcsscdValid
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        ASN1OctetString qCStatementsValue = ASN1OctetString.getInstance((Object)certificate.getExtensionValue(QcUtils.QC_OID.getId()));
        ASN1Sequence qCStatements = ASN1Sequence.getInstance((Object)qCStatementsValue.getOctets());
        for (ASN1Sequence qcStatement : qCStatements) {
            ASN1ObjectIdentifier statementId = (ASN1ObjectIdentifier)qcStatement.getObjectAt(0);
            if (!statementId.equals((ASN1Primitive)QcUtils.id_etsi_qcs_QcSSCD) || qcStatement.size() == 1) continue;
            return LintResult.of(Status.ERROR, "parsed QcStatem is not an EtsiQcSSCD value");
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return QcUtils.isEtsiQcStatementPresent(certificate, QcUtils.id_etsi_qcs_QcSSCD);
    }
}

