/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyPurposeId;

@Lint(name="e_sub_cert_eku_server_auth_client_auth_missing", description="Subscriber certificates MUST have have either id-kp-serverAuth or id-kp-clientAuth or both present in extKeyUsage", citation="BRs: 7.1.2.3", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABEffectiveDate)
public class SubCertEkuServerAuthClientAuthMissing
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        KeyPurposeId[] usages;
        byte[] rawExtendedKeyUsage = certificate.getExtensionValue(Extension.extendedKeyUsage.getId());
        ExtendedKeyUsage extendedKeyUsage = ExtendedKeyUsage.getInstance((Object)ASN1OctetString.getInstance((Object)rawExtendedKeyUsage).getOctets());
        List<String> mandatoryUsages = Arrays.asList(KeyPurposeId.id_kp_serverAuth.getId(), KeyPurposeId.id_kp_clientAuth.getId());
        for (KeyPurposeId keyPurposeId : usages = extendedKeyUsage.getUsages()) {
            if (!mandatoryUsages.contains(keyPurposeId.getId())) continue;
            return LintResult.of(Status.PASS);
        }
        return LintResult.of(Status.ERROR);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtendedKeyUsageExtension(certificate);
    }
}

