/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

@Lint(name="e_sub_cert_crl_distribution_points_does_not_contain_url", description="Subscriber certificate cRLDistributionPoints extension must contain the HTTP URL of the CA\u2019s CRL service", citation="BRs: 7.1.2.3", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABEffectiveDate)
public class SubCertCrlDistributionPointsDoesNotContainUrl
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        DistributionPoint[] distributionPoints;
        CRLDistPoint cRLDPs;
        byte[] rawCRLDPs = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        try {
            cRLDPs = CRLDistPoint.getInstance((Object)ASN1OctetString.getInstance((Object)rawCRLDPs).getOctets());
        }
        catch (Exception ex) {
            return LintResult.of(Status.FATAL);
        }
        for (DistributionPoint distributionPoint : distributionPoints = cRLDPs.getDistributionPoints()) {
            boolean match;
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName.getType() != 0 || (match = this.startsWithCorrectPrefix(distributionPointName))) continue;
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasCRLDPExtension(certificate);
    }

    private boolean startsWithCorrectPrefix(DistributionPointName distributionPointName) {
        GeneralName[] generalNamesArray;
        boolean startsWithCorrectPrefix = false;
        GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
        for (GeneralName generalName : generalNamesArray = generalNames.getNames()) {
            ASN1IA5String asn1IA5String;
            if (generalName.getTagNo() != 6 || !(asn1IA5String = (ASN1IA5String)generalName.getName()).getString().startsWith("http://")) continue;
            startsWithCorrectPrefix = true;
        }
        return startsWithCorrectPrefix;
    }
}

