/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;

@Lint(name="w_sub_ca_aia_missing", description="Subordinate CA Certificate: authorityInformationAccess SHOULD be present.", citation="BRs: 7.1.2.2", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABFBRs_1_7_1_Date)
public class SubCaAiaMissingWarning
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (Utils.hasAuthorityInformationAccessExtension(certificate)) {
            return LintResult.of(Status.PASS);
        }
        return LintResult.of(Status.WARN);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isCA(certificate) && !Utils.isRootCA(certificate);
    }
}

