/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.IneffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_sub_ca_aia_missing", description="Subordinate CA Certificate: authorityInformationAccess MUST be present, with the exception of stapling.", citation="BRs: 7.1.2.2", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABEffectiveDate, ineffectiveDate=IneffectiveDate.CABFBRs_1_7_1_Date)
public class SubCaAiaMissing
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (!Utils.hasExtension(certificate, Extension.authorityInfoAccess.getId())) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isSubCA(certificate);
    }
}

