/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

@Lint(name="w_rsa_public_exponent_not_in_range", description="RSA: Public exponent SHOULD be in the range between 2^16 + 1 and 2^256 - 1", citation="BRs: 6.1.6", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABV113Date)
public class RsaPublicExponentNotInRange
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)certificate.getPublicKey();
        BigInteger exponent = rsaPublicKey.getPublicExponent();
        BigInteger lowerBound = BigInteger.valueOf(2L).pow(16).add(BigInteger.ONE);
        BigInteger upperBound = BigInteger.valueOf(2L).pow(256).subtract(BigInteger.ONE);
        if (exponent.compareTo(lowerBound) == -1 || exponent.compareTo(upperBound) == 1) {
            return LintResult.of(Status.WARN);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isPublicKeyRSA(certificate);
    }
}

