/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

@Lint(name="e_organizational_unit_name_prohibited", description="OrganizationalUnitName is prohibited if...the certificate was issued on or after September 1, 2022", citation="BRs: 7.1.4.2.2-i", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.CABFBRs_OU_Prohibited_Date)
public class OrganizationalUnitNameProhibited
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        List<AttributeTypeAndValue> organizationalUnit = Utils.getSubjectDNNameComponent(certificate, X509ObjectIdentifiers.organizationalUnitName.getId());
        if (!organizationalUnit.isEmpty()) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return !Utils.isCA(certificate);
    }
}

