/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.DateUtils;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;

@Lint(name="e_old_root_ca_rsa_mod_less_than_2048_bits", description="In a validity period beginning on or before 31 Dec 2010, root CA certificates using RSA public key algorithm MUST use a 2048 bit modulus", citation="BRs: 6.1.5", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.ZERO)
public class OldRootCaRsaModLessThan2048Bits
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)certificate.getPublicKey();
        if (rsaPublicKey.getModulus().bitLength() < 2048) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isPublicKeyRSA(certificate) && Utils.isRootCA(certificate) && !DateUtils.isIssuedOnOrAfter(certificate, EffectiveDate.NoRSA1024Date.getZonedDateTime());
    }
}

