/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.cabf_br;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="w_ext_san_critical_with_subject_dn", description="If the subject contains a distinguished name, subjectAlternateName SHOULD be non-critical", citation="RFC 5280: 4.2.1.6", source=Source.CABF_BASELINE_REQUIREMENTS, effectiveDate=EffectiveDate.RFC5280)
public class ExtSanCriticalWithSubjectDn
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        List<AttributeTypeAndValue> rdns = Utils.getSubjectDNNameComponents(certificate);
        if (!rdns.isEmpty() && Utils.isExtensionCritical(certificate, Extension.subjectAlternativeName.getId())) {
            return LintResult.of(Status.WARN);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.subjectAlternativeName.getId());
    }
}

