/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint;

import de.mtg.jzlint.IneffectiveDate;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintClassesContainer;
import de.mtg.jzlint.LintJSONResult;
import de.mtg.jzlint.LintJSONResults;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.DateUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

public class Runner {
    public static final String CHECK_APPLIES = "checkApplies";
    public static final String EXECUTE = "execute";

    public LintJSONResults lint(X509Certificate certificate) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        LintClassesContainer lintClassesContainer = LintClassesContainer.getInstance();
        List<Class> lintClasses = lintClassesContainer.getLintClasses().stream().filter(cl -> cl.isAnnotationPresent(Lint.class)).toList();
        ArrayList<LintJSONResult> result = new ArrayList<LintJSONResult>();
        for (Class lintClass : lintClasses) {
            Lint lintAnnotation;
            LintJSONResult lintResult = this.getLintResult(certificate, lintClass, lintAnnotation = lintClass.getAnnotation(Lint.class));
            if (lintResult == null) continue;
            result.add(lintResult);
        }
        return new LintJSONResults(result);
    }

    public LintJSONResult lintForClassName(X509Certificate certificate, String lintClassName) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException {
        Class<?> lintClass = Class.forName(lintClassName);
        Lint lintAnnotation = lintClass.getAnnotation(Lint.class);
        return this.getLintResult(certificate, lintClass, lintAnnotation);
    }

    public LintJSONResult lint(X509Certificate certificate, String lintName) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        LintClassesContainer lintClassesContainer = LintClassesContainer.getInstance();
        List<Class> lintClasses = lintClassesContainer.getLintClasses().stream().filter(cl -> cl.isAnnotationPresent(Lint.class)).toList();
        for (Class lintClass : lintClasses) {
            Lint lintAnnotation = lintClass.getAnnotation(Lint.class);
            String name = lintAnnotation.name();
            if (lintName != null && !name.equalsIgnoreCase(lintName)) continue;
            return this.getLintResult(certificate, lintClass, lintAnnotation);
        }
        return new LintJSONResult(lintName, Status.NA);
    }

    public LintJSONResult lintForClassName(X509CRL crl, String lintClassName) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException {
        Class<?> lintClass = Class.forName(lintClassName);
        Lint lintAnnotation = lintClass.getAnnotation(Lint.class);
        return this.getLintResult(crl, lintClass, lintAnnotation);
    }

    public LintJSONResult lint(X509CRL crl, String lintName) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        LintClassesContainer lintClassesContainer = LintClassesContainer.getInstance();
        List<Class> lintClasses = lintClassesContainer.getLintClasses().stream().filter(cl -> cl.isAnnotationPresent(Lint.class)).toList();
        for (Class lintClass : lintClasses) {
            Lint lintAnnotation = lintClass.getAnnotation(Lint.class);
            String name = lintAnnotation.name();
            if (lintName != null && !name.equalsIgnoreCase(lintName)) continue;
            return this.getLintResult(crl, lintClass, lintAnnotation);
        }
        return new LintJSONResult(lintName, Status.NA);
    }

    private LintJSONResult getLintResult(X509Certificate certificate, Class<?> lintClass, Lint lintAnnotation) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Method checkAppliesMethod;
        try {
            checkAppliesMethod = lintClass.getMethod(CHECK_APPLIES, X509Certificate.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        Method executeMethod = lintClass.getMethod(EXECUTE, X509Certificate.class);
        Object object = lintClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        boolean checkApplies = (Boolean)checkAppliesMethod.invoke(object, certificate);
        if (checkApplies) {
            if (!DateUtils.isIssuedOnOrAfter(certificate, lintAnnotation.effectiveDate().getZonedDateTime())) {
                return new LintJSONResult(lintAnnotation.name(), Status.NE);
            }
            if (IneffectiveDate.EMPTY != lintAnnotation.ineffectiveDate() && DateUtils.isIssuedOnOrAfter(certificate, lintAnnotation.ineffectiveDate().getZonedDateTime())) {
                return new LintJSONResult(lintAnnotation.name(), Status.NE);
            }
            LintResult lintResult = (LintResult)executeMethod.invoke(object, certificate);
            return new LintJSONResult(lintAnnotation.name(), lintResult.getStatus());
        }
        return new LintJSONResult(lintAnnotation.name(), Status.NA);
    }

    private LintJSONResult getLintResult(X509CRL crl, Class<?> lintClass, Lint lintAnnotation) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Method checkAppliesMethod = lintClass.getMethod(CHECK_APPLIES, X509CRL.class);
        Method executeMethod = lintClass.getMethod(EXECUTE, X509CRL.class);
        Object object = lintClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        boolean checkApplies = (Boolean)checkAppliesMethod.invoke(object, crl);
        if (checkApplies) {
            if (!DateUtils.isIssuedOnOrAfter(crl, lintAnnotation.effectiveDate().getZonedDateTime())) {
                return new LintJSONResult(lintAnnotation.name(), Status.NE);
            }
            if (IneffectiveDate.EMPTY != lintAnnotation.ineffectiveDate() && DateUtils.isIssuedOnOrAfter(crl, lintAnnotation.ineffectiveDate().getZonedDateTime())) {
                return new LintJSONResult(lintAnnotation.name(), Status.NE);
            }
            LintResult lintResult = (LintResult)executeMethod.invoke(object, crl);
            return new LintJSONResult(lintAnnotation.name(), lintResult.getStatus());
        }
        return new LintJSONResult(lintAnnotation.name(), Status.NA);
    }
}

