/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.utils;

import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.util.encoders.Base64;

public final class ASN1CertificateUtils {
    public static final int VALIDITY_POSITION_V2_V3 = 4;
    public static final int SERIAL_NUMBER_POSITION_V2_V3 = 1;
    public static final int SUBJECTPUBLICKEYINFO_POSITION_V2_V3 = 6;
    public static final int SUBJECT_POSITION_V2_V3 = 5;
    public static final int ISSUER_POSITION_V2_V3 = 3;
    public static final int SIGNATURE_POSITION_V2_V3 = 2;
    public static final int TBS_CERTIFICATE_POSITION = 0;

    private ASN1CertificateUtils() {
    }

    public static ASN1Sequence getCertificateAsSequence(X509Certificate certificate) throws CertificateEncodingException {
        return ASN1Sequence.getInstance((Object)certificate.getEncoded());
    }

    public static ASN1Sequence getTBSCertificate(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence asn1Certificate = ASN1CertificateUtils.getCertificateAsSequence(certificate);
        return (ASN1Sequence)asn1Certificate.getObjectAt(0);
    }

    public static ASN1Sequence getValidity(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence tbsCertificate = ASN1CertificateUtils.getTBSCertificate(certificate);
        if (!ASN1CertificateUtils.isVersionEncoded(tbsCertificate)) {
            return (ASN1Sequence)tbsCertificate.getObjectAt(3);
        }
        return (ASN1Sequence)tbsCertificate.getObjectAt(4);
    }

    public static ASN1Encodable getNotBefore(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence validity = ASN1CertificateUtils.getValidity(certificate);
        return validity.getObjectAt(0);
    }

    public static ASN1Encodable getNotAfter(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence validity = ASN1CertificateUtils.getValidity(certificate);
        return validity.getObjectAt(1);
    }

    public static boolean notBeforeIsGeneralizedTime(X509Certificate certificate) throws CertificateEncodingException, IOException {
        ASN1Encodable notBefore = ASN1CertificateUtils.getNotBefore(certificate);
        return notBefore.toASN1Primitive().getEncoded("DER")[0] == 24;
    }

    public static boolean notBeforeIsUTCTime(X509Certificate certificate) throws CertificateEncodingException, IOException {
        ASN1Encodable notBefore = ASN1CertificateUtils.getNotBefore(certificate);
        return notBefore.toASN1Primitive().getEncoded("DER")[0] == 23;
    }

    public static boolean notAfterIsGeneralizedTime(X509Certificate certificate) throws CertificateEncodingException, IOException {
        ASN1Encodable notBefore = ASN1CertificateUtils.getNotAfter(certificate);
        return notBefore.toASN1Primitive().getEncoded("DER")[0] == 24;
    }

    public static boolean notAfterIsUTCTime(X509Certificate certificate) throws CertificateEncodingException, IOException {
        ASN1Encodable notBefore = ASN1CertificateUtils.getNotAfter(certificate);
        return notBefore.toASN1Primitive().getEncoded("DER")[0] == 23;
    }

    public static boolean generalizedTimeHasFractionSeconds(ASN1GeneralizedTime generalizedTime) {
        String time = generalizedTime.getTimeString();
        return time.length() > 15;
    }

    public static boolean generalizedTimeHasNotSeconds(ASN1GeneralizedTime generalizedTime) {
        String time = generalizedTime.getTimeString();
        Pattern pattern = Pattern.compile("\\d{14}Z");
        Matcher matcher = pattern.matcher(time);
        return !matcher.matches();
    }

    public static boolean isZulu(ASN1GeneralizedTime generalizedTime) throws IOException {
        byte[] encodedTime = generalizedTime.getEncoded("DER");
        return encodedTime[encodedTime.length - 1] == 90;
    }

    public static ASN1Integer getSerialNumber(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence tbsCertificate = ASN1CertificateUtils.getTBSCertificate(certificate);
        if (!ASN1CertificateUtils.isVersionEncoded(tbsCertificate)) {
            return (ASN1Integer)tbsCertificate.getObjectAt(0);
        }
        return (ASN1Integer)tbsCertificate.getObjectAt(1);
    }

    public static ASN1Sequence getPublicKey(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence tbsCertificate = ASN1CertificateUtils.getTBSCertificate(certificate);
        if (!ASN1CertificateUtils.isVersionEncoded(tbsCertificate)) {
            return (ASN1Sequence)tbsCertificate.getObjectAt(5);
        }
        return (ASN1Sequence)tbsCertificate.getObjectAt(6);
    }

    public static Optional<ASN1Encodable> getPublicKeyParameters(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence publicKey = ASN1CertificateUtils.getPublicKey(certificate);
        ASN1Sequence algorithmIdentifier = (ASN1Sequence)publicKey.getObjectAt(0);
        if (algorithmIdentifier.size() == 2) {
            return Optional.of(algorithmIdentifier.getObjectAt(1));
        }
        return Optional.empty();
    }

    public static ASN1Sequence getPublicKeyAlgorithmIdentifier(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence publicKey = ASN1CertificateUtils.getPublicKey(certificate);
        return (ASN1Sequence)publicKey.getObjectAt(0);
    }

    public static byte[] getPublicKeySubjectPublicKey(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence publicKey = ASN1CertificateUtils.getPublicKey(certificate);
        ASN1BitString subjectPublicKey = (ASN1BitString)publicKey.getObjectAt(1);
        return subjectPublicKey.getOctets();
    }

    public static String getPublicKeySubjectPublicKeyBase64Encoded(X509Certificate certificate) throws CertificateEncodingException {
        return new String(Base64.encode((byte[])ASN1CertificateUtils.getPublicKeySubjectPublicKey(certificate)));
    }

    public static ASN1Encodable getSubject(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence tbsCertificate = ASN1CertificateUtils.getTBSCertificate(certificate);
        if (!ASN1CertificateUtils.isVersionEncoded(tbsCertificate)) {
            return tbsCertificate.getObjectAt(4);
        }
        return tbsCertificate.getObjectAt(5);
    }

    public static ASN1Encodable getIssuer(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence tbsCertificate = ASN1CertificateUtils.getTBSCertificate(certificate);
        if (!ASN1CertificateUtils.isVersionEncoded(tbsCertificate)) {
            return tbsCertificate.getObjectAt(2);
        }
        return tbsCertificate.getObjectAt(3);
    }

    public static ASN1Encodable getInnerSignature(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence tbsCertificate = ASN1CertificateUtils.getTBSCertificate(certificate);
        if (!ASN1CertificateUtils.isVersionEncoded(tbsCertificate)) {
            return tbsCertificate.getObjectAt(1);
        }
        return tbsCertificate.getObjectAt(2);
    }

    public static String getInnerSignatureOID(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence innerSignature = (ASN1Sequence)ASN1CertificateUtils.getInnerSignature(certificate);
        return ((ASN1ObjectIdentifier)innerSignature.getObjectAt(0)).getId();
    }

    public static ASN1Encodable getOuterSignature(X509Certificate certificate) throws CertificateEncodingException {
        ASN1Sequence certificateSequence = ASN1CertificateUtils.getCertificateAsSequence(certificate);
        return certificateSequence.getObjectAt(1);
    }

    private static boolean isVersionEncoded(ASN1Sequence tbsCertificate) {
        return tbsCertificate.getObjectAt(0) instanceof ASN1TaggedObject && ((ASN1TaggedObject)tbsCertificate.getObjectAt(0)).getTagNo() == 0;
    }
}

