/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.ASN1CertificateUtils;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;

@Lint(name="e_subject_not_dn", description="When not empty, the subject field MUST be a distinguished name", citation="RFC 5280: 4.1.2.6", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class SubjectNotDn
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        try {
            byte[] encodedSubject;
            ASN1Encodable subject = ASN1CertificateUtils.getSubject(certificate);
            try {
                encodedSubject = subject.toASN1Primitive().getEncoded("DER");
            }
            catch (IOException ex) {
                return LintResult.of(Status.FATAL);
            }
            try {
                X500Name.getInstance((Object)encodedSubject);
            }
            catch (Exception ex) {
                return LintResult.of(Status.ERROR);
            }
        }
        catch (CertificateEncodingException ex) {
            return LintResult.of(Status.FATAL);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return true;
    }
}

