/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;

@Lint(name="e_rsa_allowed_ku_no_encipherment_ca", description="If Key usage value keyCertSign or cRLSign is present in a CA certificate both keyEncipherment and dataEncipherment SHOULD NOT be present", citation="RFC 3279: 2.3.1", source=Source.RFC3279, effectiveDate=EffectiveDate.RFC3279)
public class RsaAllowedKuNoEnciphermentCa
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawKeyUsage = certificate.getExtensionValue(Extension.keyUsage.getId());
        KeyUsage keyUsage = KeyUsage.getInstance((Object)ASN1OctetString.getInstance((Object)rawKeyUsage).getOctets());
        ArrayList<String> disallowedKUs = new ArrayList<String>();
        if (keyUsage.hasUsages(4) || keyUsage.hasUsages(2)) {
            this.checkKeyUsage(keyUsage, disallowedKUs, 32, "keyEncipherment");
            this.checkKeyUsage(keyUsage, disallowedKUs, 16, "dataEncipherment");
        }
        if (!disallowedKUs.isEmpty()) {
            return LintResult.of(Status.ERROR, "CA certificate with an RSA key and key usage keyCertSign and/or cRLSign has additionally keyEncipherment and/or dataEncipherment key usage");
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasKeyUsageExtension(certificate) && Utils.isPublicKeyRSA(certificate) && Utils.isCA(certificate);
    }

    private void checkKeyUsage(KeyUsage keyUsage, List<String> disallowedKUs, int disallowedKU, String dissalowedKUString) {
        if (keyUsage.hasUsages(disallowedKU)) {
            disallowedKUs.add(dissalowedKUString);
        }
    }
}

