/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;

@Lint(name="e_path_len_constraint_improperly_included", description="CAs MUST NOT include the pathLenConstraint field unless the CA boolean is asserted and the keyCertSign bit is set", citation="RFC 5280: 4.2.1.9", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class PathLenConstraintImproperlyIncluded
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawBasicConstraints = certificate.getExtensionValue(Extension.basicConstraints.getId());
        ASN1Sequence basicConstraints = ASN1Sequence.getInstance((Object)ASN1OctetString.getInstance((Object)rawBasicConstraints).getOctets());
        if (basicConstraints.size() == 0) {
            return LintResult.of(Status.PASS);
        }
        if (basicConstraints.size() == 1) {
            if (basicConstraints.getObjectAt(0) instanceof ASN1Boolean) {
                return LintResult.of(Status.PASS);
            }
            return LintResult.of(Status.ERROR);
        }
        ASN1Boolean cA = (ASN1Boolean)basicConstraints.getObjectAt(0);
        if (!cA.isTrue()) {
            return LintResult.of(Status.ERROR);
        }
        if (!Utils.hasKeyUsageExtension(certificate)) {
            return LintResult.of(Status.ERROR);
        }
        byte[] rawKeyUsage = certificate.getExtensionValue(Extension.keyUsage.getId());
        KeyUsage keyUsage = KeyUsage.getInstance((Object)ASN1OctetString.getInstance((Object)rawKeyUsage).getOctets());
        if (!keyUsage.hasUsages(4)) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasBasicConstraintsExtension(certificate);
    }
}

