/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;

@Lint(name="e_ext_san_uri_relative", description="When the subjectAlternateName extension is present and a URI is used, the name MUST NOT be a relative URI", citation="RFC 5280: 4.2.1.6", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class ExtSanUriRelative
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawSAN = certificate.getExtensionValue(Extension.subjectAlternativeName.getId());
        return ExtSanUriRelative.isURIAbsolute(rawSAN);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.subjectAlternativeName.getId());
    }

    /*
     * WARNING - bad return control flow
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static LintResult isURIAbsolute(byte[] rawContent) {
        try {
            List<GeneralName> uris = Utils.getUniformResourceIdentifiers(rawContent);
            for (GeneralName generalName : uris) {
                String uriString = generalName.getName().toString();
                try {
                    URI uri = new URI(uriString);
                    if (uri.isAbsolute()) continue;
                    return LintResult.of(Status.ERROR);
                }
                catch (URISyntaxException ex) {
                    return LintResult.of(Status.ERROR);
                    return LintResult.of(Status.PASS);
                }
            }
        }
        catch (IOException ex) {
            return LintResult.of(Status.FATAL);
        }
    }
}

