/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_ext_san_space_dns_name", description="The dNSName ` ` MUST NOT be used", citation="RFC 5280: 4.2.1.6", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class ExtSanSpaceDnsName
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        try {
            List<String> dnsNames = Utils.getDNSNames(certificate);
            for (String dnsName : dnsNames) {
                if (!dnsName.equalsIgnoreCase(" ")) continue;
                return LintResult.of(Status.ERROR);
            }
        }
        catch (IOException ex) {
            return LintResult.of(Status.FATAL);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.subjectAlternativeName.getId());
    }
}

