/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_ext_name_constraints_not_in_ca", description="The name constraints extension MUST only be used in CA certificates", citation="RFC 5280: 4.2.1.10", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class ExtNameConstraintsNotInCa
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (!Utils.isCA(certificate)) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasExtension(certificate, Extension.nameConstraints.getId());
    }
}

