/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_ext_key_usage_without_bits", description="When the keyUsage extension is included, at least one bit MUST be set to 1", citation="RFC 5280: 4.2.1.3", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class ExtKeyUsageWithoutBits
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawKeyUsage = certificate.getExtensionValue(Extension.keyUsage.getId());
        ASN1BitString keyUsageValue = ASN1BitString.getInstance((Object)ASN1OctetString.getInstance((Object)rawKeyUsage).getOctets());
        if (keyUsageValue.intValue() == 0) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasKeyUsageExtension(certificate);
    }
}

