/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.List;
import org.bouncycastle.asn1.ASN1BMPString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.ASN1VisibleString;

@Lint(name="w_ext_cert_policy_explicit_text_includes_control", description="Explicit text should not include any control characters", citation="RFC 6818: 3", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC6818)
public class ExtCertPolicyExplicitTextIncludesControl
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        List<ASN1Encodable> explicitTextList = Utils.getExplicitTextList(certificate);
        for (ASN1Encodable explicitText : explicitTextList) {
            byte[] content = null;
            if (explicitText instanceof ASN1UTF8String) {
                try {
                    content = Utils.getContent((ASN1UTF8String)explicitText);
                }
                catch (IOException ex) {
                    return LintResult.of(Status.FATAL);
                }
            }
            if (explicitText instanceof ASN1BMPString) {
                try {
                    content = Utils.getContent((ASN1BMPString)explicitText);
                }
                catch (IOException ex) {
                    return LintResult.of(Status.FATAL);
                }
            }
            if (explicitText instanceof ASN1VisibleString) {
                try {
                    content = Utils.getContent((ASN1VisibleString)explicitText);
                }
                catch (IOException ex) {
                    return LintResult.of(Status.FATAL);
                }
            }
            if (content == null) continue;
            for (int i = 0; i < content.length; ++i) {
                if ((content[i] & 0xFFFFFF80) == 0) {
                    if ((content[i] & 0xFF) >= 32 && (content[i] & 0xFF) != 127) continue;
                    return LintResult.of(Status.WARN);
                }
                if ((content[i] & 0x20) == 0) {
                    if ((content[i] & 0xFF) < 32 && (content[i + 1] & 0xFF) >= -128 && (content[i + 1] & 0xFF) <= -97) {
                        return LintResult.of(Status.WARN);
                    }
                    ++i;
                    continue;
                }
                if ((content[i] & 0x10) == 0) {
                    i += 2;
                    continue;
                }
                if ((content[i] & 8) == 0) {
                    i += 3;
                    continue;
                }
                if ((content[i] & 4) == 0) {
                    i += 4;
                    continue;
                }
                if ((content[i] & 2) != 0) continue;
                i += 5;
            }
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        if (!Utils.hasCertificatePoliciesExtension(certificate)) {
            return false;
        }
        return !Utils.getExplicitTextList(certificate).isEmpty();
    }
}

