/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PolicyInformation;

@Lint(name="e_ext_cert_policy_duplicate", description="A certificate policy OID must not appear more than once in the extension", citation="RFC 5280: 4.2.1.4", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class ExtCertPolicyDuplicate
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        ArrayList<String> presentOIDs = new ArrayList<String>();
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets());
        for (PolicyInformation policyInformation : certificatePolicies.getPolicyInformation()) {
            String oid = policyInformation.getPolicyIdentifier().getId();
            boolean removed = presentOIDs.remove(oid);
            if (removed) {
                return LintResult.of(Status.ERROR);
            }
            presentOIDs.add(oid);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasCertificatePoliciesExtension(certificate);
    }
}

