/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.PolicyQualifierId;

@Lint(name="e_ext_cert_policy_disallowed_any_policy_qualifier", description="When qualifiers are used with the special policy anyPolicy, they must be limited to qualifiers identified in this section: (4.2.1.4)", citation="RFC 5280: 4.2.1.4", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC3280)
public class ExtCertPolicyDisallowedAnyPolicyQualifier
implements JavaLint {
    private static final String ANY_POLICY_OID = "2.5.29.32.0";
    private List<String> allowedQualifierOIDs = Arrays.asList(PolicyQualifierId.id_qt_unotice.getId(), PolicyQualifierId.id_qt_cps.getId());

    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets());
        for (PolicyInformation policyInformation : certificatePolicies.getPolicyInformation()) {
            ASN1Encodable[] policyQualifiers;
            if (!ANY_POLICY_OID.equals(policyInformation.getPolicyIdentifier().getId())) continue;
            ASN1Sequence policyQualifiersSequence = policyInformation.getPolicyQualifiers();
            if (policyQualifiersSequence == null) {
                return LintResult.of(Status.PASS);
            }
            for (ASN1Encodable policyQualifier : policyQualifiers = policyQualifiersSequence.toArray()) {
                ASN1ObjectIdentifier policyQualifierId = (ASN1ObjectIdentifier)((ASN1Sequence)policyQualifier).getObjectAt(0);
                String qualifierOID = policyQualifierId.getId();
                if (this.allowedQualifierOIDs.contains(qualifierOID)) continue;
                return LintResult.of(Status.ERROR);
            }
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        if (!Utils.hasCertificatePoliciesExtension(certificate)) {
            return false;
        }
        byte[] rawCertificatePolicies = certificate.getExtensionValue(Extension.certificatePolicies.getId());
        CertificatePolicies certificatePolicies = CertificatePolicies.getInstance((Object)ASN1OctetString.getInstance((Object)rawCertificatePolicies).getOctets());
        for (PolicyInformation policyInformation : certificatePolicies.getPolicyInformation()) {
            if (!ANY_POLICY_OID.equals(policyInformation.getPolicyIdentifier().getId())) continue;
            return true;
        }
        return false;
    }
}

