/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;

@Lint(name="e_ext_aia_marked_critical", description="Conforming e_ext_aia_marked_critical must mark the Authority Information Access extension as non-critical", citation="RFC 5280: 4.2.2.1", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC2459)
public class ExtAiaMarkedCritical
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        if (Utils.isAuthorityInformationAccessExtensionCritical(certificate)) {
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasAuthorityInformationAccessExtension(certificate);
    }
}

