/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;

@Lint(name="n_ecdsa_ee_invalid_ku", description="ECDSA end-entity certificates MAY have key usages: digitalSignature, nonRepudiation and keyAgreement", citation="RFC 5480 Section 3", source=Source.RFC5480, effectiveDate=EffectiveDate.CABEffectiveDate)
public class EcdsaEeInvalidKu
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        byte[] rawKeyUsage = certificate.getExtensionValue(Extension.keyUsage.getId());
        KeyUsage keyUsage = KeyUsage.getInstance((Object)ASN1OctetString.getInstance((Object)rawKeyUsage).getOctets());
        if (keyUsage.hasUsages(2) || keyUsage.hasUsages(16) || keyUsage.hasUsages(32768) || keyUsage.hasUsages(1) || keyUsage.hasUsages(4) || keyUsage.hasUsages(32)) {
            return LintResult.of(Status.NOTICE);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.isSubscriberCert(certificate) && Utils.hasKeyUsageExtension(certificate) && Utils.isPublicKeyECC(certificate);
    }
}

