/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;

@Lint(name="w_distribution_point_missing_ldap_or_uri", description="When present in the CRLDistributionPoints extension, DistributionPointName SHOULD include at least one LDAP or HTTP URI", citation="RFC 5280: 4.2.1.13", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC5280)
public class DistributionPointMissingLdapOrUri
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        DistributionPoint[] distributionPoints;
        CRLDistPoint cRLDPs;
        byte[] rawCRLDPs = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (rawCRLDPs == null) {
            return LintResult.of(Status.FATAL);
        }
        try {
            cRLDPs = CRLDistPoint.getInstance((Object)ASN1OctetString.getInstance((Object)rawCRLDPs).getOctets());
        }
        catch (Exception ex) {
            return LintResult.of(Status.FATAL);
        }
        for (DistributionPoint distributionPoint : distributionPoints = cRLDPs.getDistributionPoints()) {
            boolean match;
            DistributionPointName distributionPointName = distributionPoint.getDistributionPoint();
            if (distributionPointName.getType() != 0 || (match = this.startsWithCorrectPrefix(distributionPointName))) continue;
            return LintResult.of(Status.WARN);
        }
        return LintResult.of(Status.PASS);
    }

    private boolean startsWithCorrectPrefix(DistributionPointName distributionPointName) {
        GeneralName[] generalNamesArray;
        boolean startsWithCorrectPrefix = false;
        GeneralNames generalNames = (GeneralNames)distributionPointName.getName();
        for (GeneralName generalName : generalNamesArray = generalNames.getNames()) {
            ASN1IA5String asn1IA5String;
            if (generalName.getTagNo() != 6 || !(asn1IA5String = (ASN1IA5String)generalName.getName()).getString().startsWith("http://") && !asn1IA5String.getString().startsWith("ldap://")) continue;
            startsWithCorrectPrefix = true;
        }
        return startsWithCorrectPrefix;
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasCRLDPExtension(certificate);
    }
}

