/*
 * Decompiled with CFR 0.152.
 */
package de.mtg.jzlint.lints.rfc;

import de.mtg.jzlint.EffectiveDate;
import de.mtg.jzlint.JavaLint;
import de.mtg.jzlint.Lint;
import de.mtg.jzlint.LintResult;
import de.mtg.jzlint.Source;
import de.mtg.jzlint.Status;
import de.mtg.jzlint.utils.Utils;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.Extension;

@Lint(name="e_distribution_point_incomplete", description="A DistributionPoint from the CRLDistributionPoints extension MUST NOT consist of only the reasons field; either distributionPoint or CRLIssuer must be present", citation="RFC 5280: 4.2.1.13", source=Source.RFC5280, effectiveDate=EffectiveDate.RFC3280)
public class DistributionPointIncomplete
implements JavaLint {
    @Override
    public LintResult execute(X509Certificate certificate) {
        DistributionPoint[] distributionPoints;
        CRLDistPoint cRLDPs;
        byte[] rawCRLDPs = certificate.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (rawCRLDPs == null) {
            return LintResult.of(Status.FATAL);
        }
        try {
            cRLDPs = CRLDistPoint.getInstance((Object)ASN1OctetString.getInstance((Object)rawCRLDPs).getOctets());
        }
        catch (Exception ex) {
            return LintResult.of(Status.FATAL);
        }
        for (DistributionPoint distributionPoint : distributionPoints = cRLDPs.getDistributionPoints()) {
            if (distributionPoint.getReasons() == null || distributionPoint.getCRLIssuer() != null || distributionPoint.getDistributionPoint() != null) continue;
            return LintResult.of(Status.ERROR);
        }
        return LintResult.of(Status.PASS);
    }

    @Override
    public boolean checkApplies(X509Certificate certificate) {
        return Utils.hasCRLDPExtension(certificate);
    }
}

